/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.httpclient;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.IDeviceMgmt;
import com.tplink.eap.cloudsdk.httpclient.CustomHttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppHttpClient
extends CustomHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AppHttpClient.class);
    private static final String CHARSET_UFT8 = "UTF-8";
    private static final String DEFAILT_SMB_WAP_HOST = "n-wap-smb.tplinkcloud.com";
    private static final String DEFAULT_SMB_EAP_PATH_PREFIX = "eap/v1";
    public static final String KEY_METHOD = "method";
    public static final String KEY_PARAMS = "params";
    public static final String KEY_APP_TYPE = "appType";
    public static final String KEY_TERMINAL_UUID = "terminalUUID";
    public static final String KEY_TOKEN = "token";
    public static final String METHOD_VAL_LOGIN = "login";
    public static final String URL_LEAF_PATH_APPLY_SOFTWARE_DEVICE_ID = "applySoftwareDeviceId";
    public static final String KEY_CLOUD_USER_NAME = "cloudUserName";
    public static final String KEY_CLOUD_PASSWORD = "cloudPassword";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_DEVICE_MAC = "deviceMac";
    public static final String KEY_HW_ID = "hwId";
    public static final String KEY_DEVICE_MODEL = "deviceModel";
    public static final String KEY_DEVICE_HW_VER = "deviceHwVer";
    public static final String KEY_DEVICE_TYPE = "deviceType";
    public static final String KEY_FW_ID = "fwId";
    public static final String KEY_OEM_ID = "oemId";
    public static final String KEY_FW_VER = "fwVer";
    public static final String KEY_TCSP_VER = "tcspVer";
    public static final String KEY_CONTROLLER_VERSION = "controllerVersion";
    public static final String KEY_ERROR_CODE = "error_code";
    public static final String KEY_RESULT = "result";
    public static final String KEY_VALIDATE_HOST = "validateHost";
    private static final int ERROR_CODE_VAL_GENERIC_ERROR = -10000;
    private String host = "n-wap-smb.tplinkcloud.com";
    private String pathPrefix = "eap/v1";
    IDeviceMgmt deviceMgmt;

    public AppHttpClient(IDeviceMgmt deviceMgmt) {
        this.deviceMgmt = deviceMgmt;
    }

    public JSONObject applySoftwareDeviceId(Map<String, String> urlParams, String cloudUserName, String cloudPassword) throws IOException {
        if (urlParams == null || cloudUserName == null || cloudPassword == null) {
            logger.error("Invalid parameter.");
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        DeviceInfo devInfo = this.deviceMgmt.getDeviceInfo();
        JSONObject response = this.login(devInfo, urlParams, cloudUserName, cloudPassword);
        if (response != null && response.has(KEY_ERROR_CODE) && response.getInt(KEY_ERROR_CODE) == 0) {
            JSONObject result;
            if (response.has(KEY_RESULT) && (result = response.getJSONObject(KEY_RESULT)).has(KEY_TOKEN)) {
                String token = result.getString(KEY_TOKEN);
                urlParams.put(KEY_TOKEN, token);
            }
        } else {
            logger.warn("Failed to login automatically when applys software device id.");
            return response;
        }
        response = null;
        String url = this.buildURL(URL_LEAF_PATH_APPLY_SOFTWARE_DEVICE_ID, urlParams);
        JSONObject request = this.buildApplySoftwareDeviceIdRequest(devInfo, cloudUserName, cloudPassword);
        if (request == null) {
            return null;
        }
        String responseStr = this.sendPostRequest(url, headers, request.toString(), 35, 30);
        if (responseStr != null) {
            response = JSONObject.fromObject((Object)responseStr);
        }
        if (response == null) {
            response = new JSONObject();
            response.put((Object)KEY_ERROR_CODE, (Object)-10000);
        }
        return response;
    }

    private String buildURL(String leafPath, Map<String, String> urlParams) {
        StringBuilder url = new StringBuilder();
        url.append("https://");
        url.append(this.host);
        if (!StringUtils.isBlank((String)leafPath)) {
            url.append("/");
            url.append(this.pathPrefix);
            url.append("/");
            url.append(leafPath);
        }
        url.append("?");
        Iterator<String> iterator = urlParams.keySet().iterator();
        while (iterator.hasNext()) {
            String value;
            String key = iterator.next();
            url.append(key);
            url.append("=");
            try {
                value = URLEncoder.encode(urlParams.get(key), CHARSET_UFT8);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn(e.toString(), (Throwable)e);
                value = urlParams.get(key);
            }
            url.append(value);
            if (!iterator.hasNext()) continue;
            url.append("&");
        }
        return url.toString();
    }

    private JSONObject buildApplySoftwareDeviceIdRequest(DeviceInfo devInfo, String cloudUserName, String cloudPassword) {
        JSONObject request = new JSONObject();
        if (devInfo == null || !devInfo.validateLegalityWithoutDeviceId()) {
            logger.error("Device information from deviceMgmt is illegal.");
            return request;
        }
        request.put((Object)KEY_CLOUD_USER_NAME, (Object)cloudUserName);
        request.put((Object)KEY_CLOUD_PASSWORD, (Object)cloudPassword);
        request.put((Object)KEY_DEVICE_NAME, (Object)devInfo.getDeviceName());
        request.put((Object)KEY_ALIAS, (Object)devInfo.getAlias());
        request.put((Object)KEY_DEVICE_MAC, (Object)devInfo.getDeviceMac());
        request.put((Object)KEY_HW_ID, (Object)devInfo.getHwId());
        request.put((Object)KEY_DEVICE_MODEL, (Object)devInfo.getDeviceModel());
        request.put((Object)KEY_DEVICE_HW_VER, (Object)devInfo.getDeviceHwVer());
        request.put((Object)KEY_DEVICE_TYPE, (Object)devInfo.getDeviceType());
        request.put((Object)KEY_FW_ID, (Object)devInfo.getFwId());
        request.put((Object)KEY_OEM_ID, (Object)devInfo.getOemId());
        request.put((Object)KEY_FW_VER, (Object)devInfo.getFwVer());
        request.put((Object)KEY_TCSP_VER, (Object)"1.2");
        request.put((Object)KEY_CONTROLLER_VERSION, (Object)devInfo.getControllerVersion());
        return request;
    }

    private JSONObject login(DeviceInfo devInfo, Map<String, String> urlParams, String cloudUserName, String cloudPassword) throws IOException {
        if (urlParams == null || cloudUserName == null || cloudPassword == null) {
            logger.error("Invalid parameter.");
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject response = null;
        String url = this.buildURL(null, urlParams);
        JSONObject request = new JSONObject();
        JSONObject params = new JSONObject();
        params.put((Object)KEY_CLOUD_USER_NAME, (Object)cloudUserName);
        params.put((Object)KEY_CLOUD_PASSWORD, (Object)cloudPassword);
        params.put((Object)KEY_APP_TYPE, (Object)devInfo.getDeviceType());
        params.put((Object)KEY_TERMINAL_UUID, (Object)urlParams.get("termID"));
        request.put((Object)KEY_METHOD, (Object)METHOD_VAL_LOGIN);
        request.put((Object)KEY_PARAMS, (Object)params);
        String responseStr = this.sendPostRequest(url, headers, request.toString(), 35, 30);
        if (responseStr != null) {
            response = JSONObject.fromObject((Object)responseStr);
        }
        return response;
    }
}

